//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Text;
using System.Net.Sockets;

class Listener
{

	public static void Main()
	{
		Console.WriteLine("Gotowy do przetwarzania da...");
		ProcessRequests();	
	}

	public static void ProcessRequests()
	{
		UdpClient listener = new UdpClient(2001);
		IPEndPoint remoteEp = new IPEndPoint(IPAddress.Any, 2001);

		bool continueProcessing = true;
		while(continueProcessing)
		{
			byte[] buffer = listener.Receive(ref remoteEp);
			
			string message = Encoding.ASCII.GetString(buffer, 0, buffer.Length);
			if(message == "quit")
			{
				continueProcessing = false;
				break;
			}
			else
			{
				Console.WriteLine("Otrzymana wiadomo to " + message);
			}
		}		

		listener.Close();
	}
}
